<#ibiztemplate>
TARGET=PSDATAENTITY
</#ibiztemplate>
<#if de.getUserTag()?? && de.getUserTag()=='elasticsearch'>
package ${pub.getPKGCodeName()}.core.es.service.impl;

import com.google.common.collect.Lists;
import ${pub.getPKGCodeName()}.core.es.dao.${item.getCodeName()}ESRepository;
import ${pub.getPKGCodeName()}.core.es.domain.${item.getCodeName()};
import ${pub.getPKGCodeName()}.core.es.service.I${item.getCodeName()}ESService;
import ${pub.getPKGCodeName()}.core.valuerule.filter.${item.getCodeName()}SearchContext;
import ${pub.getPKGCodeName()}.util.helper.CachedBeanCopier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;
import java.util.Collection;

/**
 * 实体[${item.getLogicName()}] 服务对象接口实现
 */
@Service
public class ${item.getCodeName()}ESServiceImpl implements I${de.getCodeName()}ESService {

    @Autowired
    @Lazy
    ${item.getCodeName()}ESRepository repository;
<#assign keyfield=de.getKeyPSDEField()>
<#comment>输出实体行为</#comment>
<#if item.getAllPSDEActions()??>
    <#list item.getAllPSDEActions() as deaction>
        <#if deaction.getCodeName()?lower_case == 'get'>
    @Override
    public ${item.getCodeName()} get(${srfr7javatype(keyfield.stdDataType)} key) {
        Optional<${item.getCodeName()}> result = repository.findById(key);
        if(!result.isPresent()){
            ${item.getCodeName()} et=new ${item.getCodeName()}();
            et.set${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}(key);
            return et;
        }
        else{
            ${item.getCodeName()} et=result.get();
            return et;
        }
    }
        <#elseif deaction.getCodeName()?lower_case == "create">
    @Override
    public boolean create(${item.getCodeName()} et) {
        repository.save(et);
        CachedBeanCopier.copy(get(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()),et);
        return true;
    }

    @Override
    public void createBatch(List<${item.getCodeName()}> list) {

    }

        <#elseif deaction.getCodeName()?lower_case == "update">
    @Override
    public boolean update(${item.getCodeName()} et) {
        repository.save(et);
        CachedBeanCopier.copy(get(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()),et);
        return true;
    }

    @Override
    public void updateBatch(List<${item.getCodeName()}> list) {

    }

        <#elseif deaction.getCodeName()?lower_case == "save">
    @Override
    public boolean save(${item.getCodeName()} et) {
        repository.save(et);
        CachedBeanCopier.copy(get(et.get${srfcaseformat(keyfield.codeName,'l_u2lC')?cap_first}()),et);
        return true;
    }

    @Override
    public void saveBatch(List<${item.getCodeName()}> list) {

    }

        <#elseif deaction.getCodeName()?lower_case == "remove">
    @Override
    public boolean remove(${srfr7javatype(keyfield.stdDataType)} key) {
        repository.deleteById(key);
        return true;
    }

    @Override
    public void removeBatch(Collection<${srfr7javatype(keyfield.stdDataType)}> idList) {

    }
        </#if>
    </#list>
</#if>
<#comment>输出实体数据集</#comment>
    <#if item.getAllPSDEDataSets()??>
        <#list item.getAllPSDEDataSets() as dedataset>
    public Page<${item.getCodeName()}> search${dedataset.getCodeName()}(${item.codeName}SearchContext context){
        Iterable<${item.getCodeName()}> list= repository.search(context.getEsCond());
        List<${item.getCodeName()}> entities = Lists.newArrayList(list);
        return new PageImpl<${item.getCodeName()}>(entities,context.getPageable(),entities.size());
    }
        </#list>
    </#if>
}
</#if>